#include "ScnOptions.h"
#include "freestyledash.h"
#include "ntp.cpp"
HRESULT CScnOptions::OnInit( XUIMessageInit* pInitData, BOOL& bHandled )
{
	return S_OK;
}


HRESULT CScnOptions::OnNotifyPress( HXUIOBJ hObjPressed, BOOL& bHandled )
{

	return S_OK;
}

HRESULT CScnOptionsMainScreen::OnInit( XUIMessageInit* pInitData, BOOL& bHandled )
{
	GetChildById( L"DateFormat", &m_DateFormat );
	GetChildById( L"TimeFormat", &m_TimeFormat );
	GetChildById( L"DisplayTemp", &m_TempStatus );
	GetChildById( L"DisplayCelsius", &m_Cels );
	GetChildById( L"DisplayDisk", &m_DiskStatus );
	GetChildById( L"DisplayIP", &m_DisplayIP );
	GetChildById( L"DisplayStatus", &m_ShowStatus);
	GetChildById( L"NTPonStartup", &m_NTP );
	GetChildById( L"NTPSyncNow", &m_NTPSync );


	if (ShowStatus)
	{
		m_ShowStatus.SetCheck(TRUE);
	} else {
		m_ShowStatus.SetCheck(FALSE);
	}

	if (TempStatus)
	{
		m_TempStatus.SetCheck(TRUE);
	} else {
		m_TempStatus.SetCheck(FALSE);
	}

	if (Cels)
	{
		m_Cels.SetCheck(TRUE);
	} else {
		m_Cels.SetCheck(FALSE);
	}

	if (DiskStatus)
	{
		m_DiskStatus.SetCheck(TRUE);
	} else {
		m_DiskStatus.SetCheck(FALSE);
	}

	if (ShowIP)
	{
		m_DisplayIP.SetCheck(TRUE);
	} else {
		m_DisplayIP.SetCheck(FALSE);
	}
	if(	NTPonStartup)
	{
		m_NTP.SetCheck(TRUE);
	}
	else
	{
		m_NTP.SetCheck(FALSE);
	}
	for (int i = 0 ; i < 5 ; i++)
	{
		m_DateFormat.SetItemCheck(i,FALSE);
	}
	m_DateFormat.SetItemCheck(DateFormat,TRUE);

	for (int i = 0 ; i < 4 ; i++)
	{
		m_TimeFormat.SetItemCheck(i,FALSE);
	}
	m_TimeFormat.SetItemCheck(TimeFormat,TRUE);

	UpdateDateTimes();

	SetTimer(TM_CLOCK,1000);

	return S_OK;
}

HRESULT CScnOptionsMainScreen::OnTimer( XUIMessageTimer *pTimer, BOOL& bHandled )
{
    // which timer is it?
    switch( pTimer->nId )
    {
		case TM_CLOCK:
			{
				UpdateDateTimes();
			}
    }
    
    bHandled = TRUE;
    
    return( S_OK );
}

HRESULT CScnOptionsMainScreen::OnNotifyPress( HXUIOBJ hObjPressed, BOOL& bHandled )
{

	if (hObjPressed == m_TempStatus)
	{
		TempStatus = 1 - TempStatus;
		m_TempStatus.SetCheck(TempStatus);
		DoSaveSettings();
		bHandled = TRUE;
	} else if (hObjPressed == m_Cels)
	{
		Cels = 1 - Cels;
		m_Cels.SetCheck(Cels);
		DoSaveSettings();
		bHandled = TRUE;
	} else if (hObjPressed == m_DiskStatus)
	{
		DiskStatus = 1 - DiskStatus;
		m_DiskStatus.SetCheck(DiskStatus);
		DoSaveSettings();
		bHandled = TRUE;
	} else if (hObjPressed == m_DisplayIP)
	{
		ShowIP = 1 - ShowIP;
		m_DisplayIP.SetCheck(ShowIP);
		DoSaveSettings();
		bHandled = TRUE;
	} else if (hObjPressed == m_ShowStatus)
	{
		ShowStatus = 1 - ShowStatus;
		m_ShowStatus.SetCheck(ShowStatus);
		DoSaveSettings();
		bHandled=TRUE;
	} else if (hObjPressed == m_DateFormat)
	{
		DateFormat = m_DateFormat.GetCurSel();
		for (unsigned int i = 0 ; i < 5 ; i++)
		{
			m_DateFormat.SetItemCheck(i,FALSE);
		}
		m_DateFormat.SetItemCheck(DateFormat,TRUE);
		DoSaveSettings();		
	} else if (hObjPressed == m_TimeFormat)
	{
		TimeFormat = m_TimeFormat.GetCurSel();
		for (unsigned int i = 0 ; i < 4 ; i++)
		{
			m_TimeFormat.SetItemCheck(i,FALSE);
		}
		m_TimeFormat.SetItemCheck(TimeFormat,TRUE);
		DoSaveSettings();		
	}
	else if(hObjPressed == m_NTPSync)
	{
		NTP::SyncTime();
	}
	else if(hObjPressed == m_NTP)
	{
		//NTP::SyncTime();
		NTPonStartup = 1-NTPonStartup;
		m_NTP.SetCheck(NTPonStartup);
		DoSaveSettings();
	}
	
    return S_OK;
}

void CScnOptionsMainScreen::UpdateDateTimes()
{
    SYSTEMTIME LocalSysTime;
    GetLocalTime( &LocalSysTime );

	for (int i = 0 ; i < 5 ; i++)
	{
		m_DateFormat.SetText(i,GetDate(i,LocalSysTime).c_str());
	}
	for (int i = 0 ; i < 4 ; i++)
	{
		m_TimeFormat.SetText(i,GetTime(i,LocalSysTime).c_str());
	}
}

HRESULT CScnOptionsGameList::OnInit( XUIMessageInit* pInitData, BOOL& bHandled )
{
	GetChildById( L"Reset", &m_Reset );
	GetChildById( L"UseBackgrounds", &m_UseBackgrounds );
	GetChildById( L"UsePreviewVideos", &m_UsePreviews );
	GetChildById( L"PCEnable", &m_PCEnabled );
	GetChildById( L"SemiTransparent", &m_SemiTransparent );

	if (UseBackgrounds)
	{
		m_UseBackgrounds.SetCheck(TRUE);
	} else {
		m_UseBackgrounds.SetCheck(FALSE);
	}

	if (UsePreviews)
	{
		m_UsePreviews.SetCheck(TRUE);
	} else {
		m_UsePreviews.SetCheck(FALSE);
	}

	if (ParentalControl)
	{
		m_PCEnabled.SetCheck(TRUE);
	} else {
		m_PCEnabled.SetCheck(FALSE);
	}

	if(SemiTransparentBackground) 
	{ 
		m_SemiTransparent.SetCheck(TRUE); 
	} else { 
		m_SemiTransparent.SetCheck(FALSE); 
	} 
 
		
	return S_OK;
}

HRESULT CScnOptionsGameList::OnNotifyPress( HXUIOBJ hObjPressed, BOOL& bHandled )
{

	if (hObjPressed == m_Reset)
	{
		_wunlink(wstring(datapath + L"content.xml").c_str());
		RestartFreestyle();
	} else if (hObjPressed == m_UseBackgrounds)
	{
		UseBackgrounds = !UseBackgrounds;
		m_UseBackgrounds.SetCheck(UseBackgrounds);
		DoSaveSettings();
		bHandled = TRUE;
	} else if (hObjPressed == m_UsePreviews)
	{
		UsePreviews = 1 - UsePreviews;
		m_UsePreviews.SetCheck(UsePreviews);
		DoSaveSettings();
		bHandled = TRUE;
	}  else if (hObjPressed == m_PCEnabled)
	{
		ParentalControl = 1 - ParentalControl;
		m_PCEnabled.SetCheck(ParentalControl);
		DoSaveSettings();
		bHandled = TRUE;
	} else if (hObjPressed == m_SemiTransparent)
	{
		SemiTransparentBackground = 1 - SemiTransparentBackground;
		m_SemiTransparent.SetCheck(SemiTransparentBackground);
		DoSaveSettings();
		bHandled = TRUE;
	}		

    return S_OK;
}

HRESULT CScnOptionsSystemSettings::OnInit( XUIMessageInit* pInitData, BOOL& bHandled )
{
    GetChildById( L"HorizOverscan", &m_HorizO );
    GetChildById( L"VertOverscan", &m_VertO );
	GetChildById( L"FanSpeed", &m_FanSpeed );
    GetChildById( L"FanSpeedText", &m_FanSpeedText );
	GetChildById( L"LedType", &m_PlayerLedType );

	m_HorizO.SetValue(HOverscan);
	m_VertO.SetValue(VOverscan);

	m_FanSpeed.SetValue(FSpeed); 
  
    for (int i = 0 ; i < 5 ; i++) 
    { 
            m_PlayerLedType.SetItemCheck(i,FALSE); 
    } 
    m_PlayerLedType.SetItemCheck(LedType,TRUE); 

	SetTimer(TM_FAN_SPEED,500); 
  
    if (FSpeed < 45) 
    { 
            SpeedText = sprintfa(L"Auto"); 
    } 
    else 
    { 
            SpeedText = sprintfa(L"%d%%", FSpeed); 
    } 
  
     m_FanSpeedText.SetText(SpeedText.c_str()); 
 
	SetTimer(TM_OVERSCAN,500); 

	return S_OK;
}

HRESULT CScnOptionsSystemSettings::OnTimer( XUIMessageTimer *pTimer, BOOL& bHandled )
{
    // which timer is it?
    switch( pTimer->nId )
    {
        case TM_OVERSCAN:
			{
				int OldH = HOverscan;
				int OldV = VOverscan;
				m_HorizO.GetValue(&HOverscan);
				m_VertO.GetValue(&VOverscan);

				if (OldH != HOverscan || OldV != VOverscan)
					DoSaveSettings();
            break;
			}
        case TM_FAN_SPEED: 
            { 
                    int OldSpeed = FSpeed; 
  
                    m_FanSpeed.GetValue(&FSpeed); 
  
					if (OldSpeed != FSpeed) 
                    { 
                            DoSaveSettings(); 
  
                            SetFanSpeed(1,FSpeed); 
  
                            if (FSpeed < 45) 
                            { 
                                    SpeedText = sprintfa(L"Auto"); 
                            } 
                            else 
                            { 
                                    SpeedText = sprintfa(L"%d%%", FSpeed); 
                            } 
  
                            m_FanSpeedText.SetText(SpeedText.c_str()); 
                    } 
                    break; 
            } 
    }
    
    bHandled = TRUE;
    
    return( S_OK );
}

HRESULT CScnOptionsSystemSettings::OnNotifyPress( HXUIOBJ hObjPressed, BOOL& bHandled )
{

	if (hObjPressed == m_PlayerLedType)
	{
		LedType = m_PlayerLedType.GetCurSel();

		for (unsigned int i = 0 ; i < 5 ; i++)
		{
			m_PlayerLedType.SetItemCheck(i,FALSE);
		}

		m_PlayerLedType.SetItemCheck(LedType,TRUE);
		

		if (LedType == 1) //Temp Led
		{
			SetTempLEDS();
		} 
		else
		{
			SetLedState(LedType);
		}
		
		DoSaveSettings();
	}	

    return S_OK;
}

HRESULT CScnOptionsChooseSkin::OnInit( XUIMessageInit* pInitData, BOOL& bHandled )
{
	GetChildById( L"Skin", &m_Skin );
	GetChildById( L"ReloadSkin", &m_Reload );

	LoadSkinList();

	return S_OK;
}

HRESULT CScnOptionsChooseSkin::OnNotifyPress( HXUIOBJ hObjPressed, BOOL& bHandled )
{

	if (hObjPressed == m_Skin)
	{
		int Current = m_Skin.GetCurSel();
		for (unsigned int i = 0 ; i < Skins.size() ; i++)
		{
			m_Skin.SetItemCheck(i,false);
		}
		m_Skin.SetItemCheck(Current,true);
		cl.skin = Skins[Current];
		DoSaveSettings();
	} else if (hObjPressed == m_Reload)
	{
		RestartFreestyle();
	}
		

    return S_OK;
}

void CScnOptionsChooseSkin::LoadSkinList()
{
	int Count = m_Skin.GetItemCount();
	m_Skin.DeleteItems(0,Count);

	WIN32_FIND_DATA findFileData;
	memset(&findFileData,0,sizeof(WIN32_FIND_DATA));
	string searchcmd = "game:\\skin\\*";
	searchcmd = str_replaceallA(searchcmd,"\\\\","\\");
	DebugMsg("Scanning %s for skins",searchcmd.c_str());

	HANDLE hFind = FindFirstFile(searchcmd.c_str(), &findFileData);
	if (hFind == INVALID_HANDLE_VALUE)
		return;

	int SkinsNo = 0;
	do {
		DebugMsg(findFileData.cFileName);
		Skins[SkinsNo] = strtowstr(findFileData.cFileName).c_str();
		SkinsNo++;
	} while (FindNextFile(hFind, &findFileData));
	FindClose(hFind);

	m_Skin.InsertItems(0,Skins.size());
	int Current = 0;

	for (unsigned int i = 0 ; i < Skins.size() ; i++)
	{
		m_Skin.SetText(i,Skins[i].c_str());
		if (Skins[i] == cl.skin)
			Current = i;
	}
	m_Skin.SetItemCheck(Current,true);
}
